/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.File;
import java.net.InetAddress;
import sedona.Buf;
import sedona.Constants;
import sedona.Int;
import sedona.KitPart;
import sedona.Link;
import sedona.Long;
import sedona.Schema;
import sedona.Slot;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.offline.OfflineLink;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxFile;
import sedona.util.ArrayUtil;
import sedona.util.UserUtil;
import sedonac.test.AbstractSoxTest;

public class SecurityTest
extends AbstractSoxTest
implements Constants {
    static final int TREE = 1;
    static final int ALL = 15;
    OfflineApp app;
    OfflineComponent service;
    OfflineComponent plat;
    OfflineComponent sox;
    OfflineComponent users;
    OfflineComponent root;
    OfflineComponent ann;
    OfflineComponent bob;
    OfflineComponent dan;
    OfflineComponent u0;
    OfflineComponent u3;
    OfflineComponent g0;
    OfflineComponent g1;
    OfflineComponent g2;
    OfflineComponent g3;
    OfflineComponent g01;
    OfflineComponent g12;
    OfflineComponent g23;
    boolean updateOrSub;

    public void doTest() throws Exception {
        this.connect("root");
        this.verifyPerm(this.g0, 127);
        this.verifyPerm(this.g1, 127);
        this.verifyPerm(this.g2, 127);
        this.verifyPerm(this.g3, 127);
        this.verifyPerm(this.g01, 127);
        this.verifyPerm(this.g23, 127);
        this.verifyUser(this.u0, true);
        this.verifyUser(this.u3, true);
        this.verifyTree(this.g2, true);
        this.verifyLink(this.g0, this.g23, true);
        this.verifyProv(this.getSvmName(), true);
        this.verifyProv("kits.scode", false);
        this.verifyProv("app.sab", false);
        this.client.close();
        this.connect("ann");
        this.verifyPerm(this.g0, 7);
        this.verifyPerm(this.g1, 0);
        this.verifyPerm(this.g2, 0);
        this.verifyPerm(this.g3, 0);
        this.verifyPerm(this.g01, 7);
        this.verifyPerm(this.g23, 0);
        this.verifyUser(this.u0, false);
        this.verifyUser(this.u3, false);
        this.verifyKids((OfflineComponent)this.app, new OfflineComponent[]{this.service, this.g0});
        this.verifyTree(this.g01, false);
        this.verifyLink(this.g0, this.g01, false);
        this.verifyProv("svm.exe", false);
        this.verifyProv("kits.scode", false);
        this.verifyProv("app.sab", true);
        this.client.close();
        this.connect("bob");
        this.verifyPerm(this.g0, 1);
        this.verifyPerm(this.g1, 0);
        this.verifyPerm(this.g2, 3);
        this.verifyPerm(this.g3, 0);
        this.verifyPerm(this.g01, 1);
        this.verifyPerm(this.g23, 3);
        this.verifyKids((OfflineComponent)this.app, new OfflineComponent[]{this.service, this.g0, this.g2});
        this.verifyTree(this.g2, false);
        this.verifyProv("svm.exe", false);
        this.verifyProv("kits.scode", true);
        this.verifyProv("app.sab", false);
        this.client.close();
        this.connect("dan");
        this.verifyPerm(this.g0, 0);
        this.verifyPerm(this.g1, 5);
        this.verifyPerm(this.g2, 43);
        this.verifyPerm(this.g3, 95);
        this.verifyPerm(this.g01, 5);
        this.verifyPerm(this.g12, 47);
        this.verifyPerm(this.g23, 127);
        this.verifyUser(this.u0, false);
        this.verifyUser(this.u3, true);
        this.verifyKids((OfflineComponent)this.app, new OfflineComponent[]{this.g1, this.g2, this.g3});
        this.verifyTree(this.g2, false);
        this.verifyTree(this.g3, true);
        this.client.close();
    }

    void verifyPerm(OfflineComponent offlineComponent, int n) throws Exception {
        System.out.println("-- " + this.client.username + ' ' + offlineComponent.name() + " 0x" + Integer.toHexString(n) + "...");
        SoxComponent soxComponent = this.verifyCompRead(offlineComponent, n);
        if (soxComponent == null) {
            return;
        }
        this.verifyEq(soxComponent.id(), offlineComponent.id());
        this.updateOrSub ^= true;
        if (this.updateOrSub) {
            this.client.subscribe(soxComponent, 15);
        } else {
            this.client.update(soxComponent, 15);
        }
        this.verifyOpRead(offlineComponent, soxComponent, n);
        this.verifyAdminRead(offlineComponent, soxComponent, n);
        this.verifyOpWrite(offlineComponent, soxComponent, n);
        this.verifyAdminWrite(offlineComponent, soxComponent, n);
        this.verifyOpInvoke(offlineComponent, soxComponent, n);
        this.verifyAdminInvoke(offlineComponent, soxComponent, n);
        this.client.unsubscribe(soxComponent, 15);
    }

    SoxComponent verifyCompRead(OfflineComponent offlineComponent, int n) throws Exception {
        SoxComponent soxComponent = null;
        Exception exception = null;
        try {
            soxComponent = this.client.load(offlineComponent.id());
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if ((n & 1) == 0) {
            boolean bl = false;
            if (soxComponent == null) {
                bl = true;
            }
            this.verify(bl);
            boolean bl2 = false;
            if (exception != null) {
                bl2 = true;
            }
            this.verify(bl2);
            exception = null;
            try {
                this.client.update(new SoxComponent(this.client, offlineComponent.id(), offlineComponent.type), 1);
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            boolean bl3 = false;
            if (exception != null) {
                bl3 = true;
            }
            this.verify(bl3);
        }
        return soxComponent;
    }

    void verifyOpRead(OfflineComponent offlineComponent, SoxComponent soxComponent, int n) throws Exception {
        this.verifyEq(this.readInt(offlineComponent, "i2"), -123456789);
        this.verifyEq(this.readLong(offlineComponent, "j1"), 111L);
        this.verifyEq(soxComponent.permissions(), n);
        this.verifyEq(soxComponent.getInt("i2"), -123456789);
        this.verifyEq(soxComponent.getLong("j1"), 111L);
    }

    void verifyAdminRead(OfflineComponent offlineComponent, SoxComponent soxComponent, int n) throws Exception {
        Exception exception = null;
        if ((n & 8) != 0) {
            this.verifyEq(this.readInt(offlineComponent, "i1"), 97);
            this.verifyEq(this.readStr(offlineComponent, "str"), "hi");
            this.verifyEq(soxComponent.getInt("i1"), 97);
            this.verifyEq(soxComponent.getDouble("d1"), 1.23456789E8);
            this.verifyEq(soxComponent.getDouble("d2"), 256.0);
            this.verifyEq(soxComponent.getStr("str"), "hi");
            this.verifyEq(soxComponent.links().length, 2);
        } else {
            try {
                this.readInt(offlineComponent, "i1");
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            boolean bl = false;
            if (exception != null) {
                bl = true;
            }
            this.verify(bl);
            exception = null;
            try {
                this.readStr(offlineComponent, "str");
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            boolean bl2 = false;
            if (exception != null) {
                bl2 = true;
            }
            this.verify(bl2);
            exception = null;
            this.verifyEq(soxComponent.getInt("i1"), 0);
            this.verifyEq(soxComponent.getDouble("d1"), 0.0);
            this.verifyEq(soxComponent.getDouble("d2"), 256.0);
            this.verifyEq(soxComponent.getStr("str"), "foo");
            this.verifyEq(soxComponent.links().length, 0);
        }
    }

    void verifyOpWrite(OfflineComponent offlineComponent, SoxComponent soxComponent, int n) throws Exception {
        Exception exception = null;
        try {
            this.client.write(soxComponent, soxComponent.type.slot("j1"), (Value)Long.make((long)188901251547427L));
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if ((n & 2) != 0) {
            this.verifyEq(this.readLong(offlineComponent, "j1"), 188901251547427L);
            this.client.write(soxComponent, soxComponent.type.slot("j1"), (Value)Long.make((long)111L));
        } else {
            boolean bl = false;
            if (exception != null) {
                bl = true;
            }
            this.verify(bl);
            this.verifyEq(this.readLong(offlineComponent, "j1"), 111L);
        }
    }

    void verifyAdminWrite(OfflineComponent offlineComponent, SoxComponent soxComponent, int n) throws Exception {
        Exception exception = null;
        try {
            this.client.write(soxComponent, soxComponent.type.slot("str"), (Value)Str.make((String)"foo"));
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if ((n & 0x10) != 0) {
            this.verifyEq(this.readStr(offlineComponent, "str"), "foo");
            this.client.write(soxComponent, soxComponent.type.slot("str"), (Value)Str.make((String)"hi"));
        } else {
            boolean bl = false;
            if (exception != null) {
                bl = true;
            }
            this.verify(bl);
            if ((n & 8) != 0) {
                this.verifyEq(this.readStr(offlineComponent, "str"), "hi");
            }
        }
    }

    void verifyOpInvoke(OfflineComponent offlineComponent, SoxComponent soxComponent, int n) throws Exception {
        Exception exception = null;
        try {
            this.client.invoke(soxComponent, soxComponent.type.slot("addJ1"), (Value)Long.make((long)2));
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if ((n & 4) != 0) {
            this.verifyEq(this.readLong(offlineComponent, "j1"), 113L);
            this.client.invoke(soxComponent, soxComponent.type.slot("addJ1"), (Value)Long.make((long)-2L));
            this.verifyEq(this.readLong(offlineComponent, "j1"), 111L);
        } else {
            boolean bl = false;
            if (exception != null) {
                bl = true;
            }
            this.verify(bl);
            this.verifyEq(this.readLong(offlineComponent, "j1"), 111L);
        }
    }

    void verifyAdminInvoke(OfflineComponent offlineComponent, SoxComponent soxComponent, int n) throws Exception {
        Exception exception = null;
        try {
            this.client.invoke(soxComponent, soxComponent.type.slot("incI1"), null);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if ((n & 0x20) != 0) {
            this.verifyEq(this.readInt(offlineComponent, "i1"), 98);
            this.client.invoke(soxComponent, soxComponent.type.slot("addI1"), (Value)Int.make((int)-1));
            this.verifyEq(this.readInt(offlineComponent, "i1"), 97);
        } else {
            boolean bl = false;
            if (exception != null) {
                bl = true;
            }
            this.verify(bl);
            if ((n & 8) != 0) {
                this.verifyEq(this.readInt(offlineComponent, "i1"), 97);
            }
        }
    }

    void verifyTree(OfflineComponent offlineComponent, boolean bl) throws Exception {
        SoxComponent soxComponent = this.client.load(offlineComponent.id());
        int n = this.client.update(soxComponent, 1).children().length;
        boolean bl2 = false;
        if (n != 0) {
            bl2 = true;
        }
        this.verify(bl2);
        Type type = this.schema.type("sys::Folder");
        Value[] valueArray = new Value[]{Int.make((int)offlineComponent.getInt("meta"))};
        if (bl) {
            SoxComponent soxComponent2 = this.client.add(soxComponent, type, "folder", valueArray);
            this.verifyEq(this.client.update(soxComponent2, 1).name(), "folder");
            this.verifyEq(this.client.update(soxComponent, 1).children().length, n + 1);
            this.verifyEq(this.client.update(soxComponent, 1).name(), offlineComponent.name());
            this.client.rename(soxComponent, "foobar");
            this.verifyEq(this.client.update(soxComponent, 1).name(), "foobar");
            this.client.rename(soxComponent, offlineComponent.name());
            this.client.delete(soxComponent2);
            this.verifyEq(this.client.update(soxComponent, 1).children().length, n);
            int[] nArray = soxComponent.childrenIds();
            ArrayUtil.swap((int[])nArray, (int)0, (int)(nArray.length - 1));
            this.client.reorder(soxComponent, nArray);
            this.verifyEq(this.client.update(soxComponent, 1).childrenIds(), nArray);
        } else {
            Exception exception = null;
            try {
                this.client.add(soxComponent, type, "folder", valueArray);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            boolean bl3 = false;
            if (exception != null) {
                bl3 = true;
            }
            this.verify(bl3);
            exception = null;
            this.verifyEq(this.client.update(soxComponent, 1).children().length, n);
            this.verifyEq(this.client.update(soxComponent, 1).name(), offlineComponent.name());
            try {
                this.client.rename(soxComponent, "foobar");
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            boolean bl4 = false;
            if (exception != null) {
                bl4 = true;
            }
            this.verify(bl4);
            exception = null;
            this.verifyEq(this.client.update(soxComponent, 1).name(), offlineComponent.name());
            try {
                this.client.delete(soxComponent);
            }
            catch (Exception exception4) {
                exception = exception4;
            }
            boolean bl5 = false;
            if (exception != null) {
                bl5 = true;
            }
            this.verify(bl5);
            exception = null;
            this.verifyEq(this.client.update(soxComponent, 1).name(), offlineComponent.name());
            int[] nArray = soxComponent.childrenIds();
            int[] nArray2 = soxComponent.childrenIds();
            ArrayUtil.swap((int[])nArray2, (int)0, (int)(nArray2.length - 1));
            try {
                this.client.reorder(soxComponent, nArray2);
            }
            catch (Exception exception5) {
                exception = exception5;
            }
            this.verifyEq(this.client.update(soxComponent, 1).childrenIds(), nArray);
            boolean bl6 = false;
            if (exception != null) {
                bl6 = true;
            }
            this.verify(bl6);
            exception = null;
        }
    }

    void verifyLink(OfflineComponent offlineComponent, OfflineComponent offlineComponent2, boolean bl) throws Exception {
        boolean bl2;
        int n = offlineComponent2.type.slot((String)"s2").id;
        Link link = new Link(offlineComponent.id(), n, offlineComponent2.id(), n);
        SoxComponent soxComponent = this.client.load(offlineComponent2.id());
        boolean bl3 = false;
        if ((soxComponent.permissions() & 8) != 0) {
            bl3 = bl2 = true;
        }
        if (bl) {
            this.client.link(link);
            Link[] linkArray = this.client.update(soxComponent, 8).links();
            this.verifyEq(linkArray.length, 3);
            this.verifyHasLink(linkArray, link);
            this.client.unlink(link);
            this.verifyEq(this.client.update(soxComponent, 8).links().length, 2);
        } else {
            Exception exception = null;
            try {
                this.client.link(link);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            Link[] linkArray = this.client.update(soxComponent, 8).links();
            this.verifyEq(linkArray.length, bl2 ? 2 : 0);
            boolean bl4 = false;
            if (exception != null) {
                bl4 = true;
            }
            this.verify(bl4);
            exception = null;
            try {
                this.client.unlink(linkArray[1]);
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            this.verifyEq(linkArray.length, bl2 ? 2 : 0);
            linkArray = this.client.update(soxComponent, 8).links();
            this.verifyEq(linkArray.length, bl2 ? 2 : 0);
            boolean bl5 = false;
            if (exception != null) {
                bl5 = true;
            }
            this.verify(bl5);
        }
    }

    void verifyHasLink(Link[] linkArray, Link link) {
        int n = 0;
        while (n < linkArray.length) {
            if (linkArray[n].equals((Object)link)) {
                return;
            }
            ++n;
        }
        this.verify(false, "Missing link " + link);
    }

    void verifyKids(OfflineComponent offlineComponent, OfflineComponent[] offlineComponentArray) throws Exception {
        SoxComponent soxComponent = this.client.load(offlineComponent.id());
        this.verifyEq(soxComponent.children().length, offlineComponentArray.length);
        int n = 0;
        while (n < offlineComponentArray.length) {
            this.verifyEq(soxComponent.children()[n].id(), offlineComponentArray[n].id());
            ++n;
        }
    }

    void verifyUser(OfflineComponent offlineComponent, boolean bl) throws Exception {
        SoxComponent soxComponent = this.verifyCompRead(offlineComponent, bl ? 63 : 0);
        if (soxComponent == null) {
            return;
        }
        this.client.update(soxComponent, 15);
        this.verifyEq(soxComponent.getInt("meta"), offlineComponent.getInt("meta"));
        this.verifyEq(soxComponent.getBuf("cred"), offlineComponent.getBuf("cred"));
        this.verifyEq(soxComponent.getInt("perm"), offlineComponent.getInt("perm"));
    }

    void verifyProv(String string, boolean bl) throws Exception {
        File file = new File(this.testDir(), "tempprov");
        file.delete();
        boolean bl2 = false;
        if (file.length() == 0L) {
            bl2 = true;
        }
        this.verify(bl2);
        Exception exception = null;
        try {
            this.client.getFile(string, SoxFile.make((File)file), null, null);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (bl) {
            boolean bl3 = false;
            if (file.length() > 0L) {
                bl3 = true;
            }
            this.verify(bl3);
            boolean bl4 = false;
            if (exception == null) {
                bl4 = true;
            }
            this.verify(bl4);
        } else {
            boolean bl5 = false;
            if (file.length() == 0L) {
                bl5 = true;
            }
            this.verify(bl5);
            boolean bl6 = false;
            if (exception != null) {
                bl6 = true;
            }
            this.verify(bl6);
        }
    }

    public void connect(String string) throws Exception {
        this.trace("Connect [" + string + "]...");
        InetAddress inetAddress = InetAddress.getLocalHost();
        this.client = new SoxClient(this.sock, inetAddress, 1876, string, "pw");
        this.client.connect(null);
        this.verify(this.client.isClosed() ^ true);
        boolean bl = false;
        if (this.client.session() != null) {
            bl = true;
        }
        this.verify(bl);
    }

    public OfflineApp buildApp() throws Exception {
        this.schema = Schema.load((KitPart[])new KitPart[]{KitPart.forLocalKit((String)"sys"), KitPart.forLocalKit((String)"sox"), KitPart.forLocalKit((String)"inet"), KitPart.forLocalKit((String)"web")});
        this.app = new OfflineApp(this.schema);
        this.app.setInt("meta", 15);
        this.service = this.app.add((OfflineComponent)this.app, new OfflineComponent(this.schema.type("sys::Component"), "service"));
        this.plat = this.app.add(this.service, new OfflineComponent(this.schema.type("sys::PlatformService"), "plat"));
        this.sox = this.app.add(this.service, new OfflineComponent(this.schema.type("sox::SoxService"), "sox"));
        this.users = this.app.add(this.service, new OfflineComponent(this.schema.type("sys::UserService"), "users"));
        this.root = this.newUser("root", 1, 0x7F7F7F7F, 4);
        this.ann = this.newUser("ann", 1, 7, 1);
        this.bob = this.newUser("bob", 1, 196609, 2);
        this.dan = this.newUser("dan", 1, 1596654848, 0);
        this.u0 = this.newUser("u0", 1, 0, 0);
        this.u3 = this.newUser("u2", 8, 0, 0);
        this.g0 = this.newComp((OfflineComponent)this.app, "g0", 1);
        this.g1 = this.newComp((OfflineComponent)this.app, "g1", 2);
        this.g2 = this.newComp((OfflineComponent)this.app, "g2", 4);
        this.g3 = this.newComp((OfflineComponent)this.app, "g3", 8);
        this.g01 = this.newComp(this.g3, "g01", 3);
        this.g12 = this.newComp(this.g3, "g12", 6);
        this.g23 = this.newComp(this.g3, "g23", 12);
        this.app.assignIds();
        return this.app;
    }

    OfflineComponent newUser(String string, int n, int n2, int n3) {
        OfflineComponent offlineComponent = this.app.add(this.users, new OfflineComponent(this.schema.type("sys::User"), string));
        offlineComponent.setInt("meta", n);
        offlineComponent.setBuf("cred", new Buf(UserUtil.credentials((String)string, (String)"pw")));
        offlineComponent.setInt("perm", n2);
        offlineComponent.setInt("prov", n3);
        return offlineComponent;
    }

    OfflineComponent newComp(OfflineComponent offlineComponent, String string, int n) {
        Type type = this.schema.type("sys::TestComp");
        OfflineComponent offlineComponent2 = new OfflineComponent(type, string);
        offlineComponent2.setInt("meta", n);
        offlineComponent2.setInt("i1", 97);
        offlineComponent2.setLong("j1", 111L);
        offlineComponent2.setDouble("d1", 1.23456789E8);
        offlineComponent2.setStr("str", "hi");
        this.app.add(offlineComponent, offlineComponent2);
        OfflineComponent offlineComponent3 = new OfflineComponent(type, "dummy1");
        offlineComponent3.setInt("meta", n);
        this.app.add(offlineComponent2, offlineComponent3);
        OfflineComponent offlineComponent4 = new OfflineComponent(type, "dummy2");
        offlineComponent4.setInt("meta", n);
        this.app.add(offlineComponent2, offlineComponent4);
        Slot slot = type.slot("f1", true);
        Slot slot2 = type.slot("f2", true);
        this.app.addLink(new OfflineLink(offlineComponent3, slot, offlineComponent2, slot));
        this.app.addLink(new OfflineLink(offlineComponent2, slot, offlineComponent4, slot2));
        return offlineComponent2;
    }
}

